Ext.data.JsonP.sol_Logger({"tagname":"class","name":"sol.Logger","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_Class.js","href":"lib_Class.html#sol-Logger"}],"author":[{"tagname":"author","name":"Pascal Zipfel, ELO Digital Office GmbH","email":null}],"version":["1.1"],"eloall":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"logger","tagname":"cfg","owner":"sol.Logger","id":"cfg-logger","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"scope","tagname":"cfg","owner":"sol.Logger","id":"cfg-scope","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"debugEnabled","tagname":"property","owner":"sol.Logger","id":"property-debugEnabled","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"pattern","tagname":"property","owner":"sol.Logger","id":"property-pattern","meta":{"private":true}},{"name":"timings","tagname":"property","owner":"sol.Logger","id":"property-timings","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"debug","tagname":"method","owner":"sol.Logger","id":"method-debug","meta":{}},{"name":"doTiming","tagname":"method","owner":"sol.Logger","id":"method-doTiming","meta":{"private":true}},{"name":"enter","tagname":"method","owner":"sol.Logger","id":"method-enter","meta":{}},{"name":"error","tagname":"method","owner":"sol.Logger","id":"method-error","meta":{}},{"name":"exit","tagname":"method","owner":"sol.Logger","id":"method-exit","meta":{}},{"name":"format","tagname":"method","owner":"sol.Logger","id":"method-format","meta":{"private":true}},{"name":"info","tagname":"method","owner":"sol.Logger","id":"method-info","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Logger","id":"method-initialize","meta":{"private":true}},{"name":"noop","tagname":"method","owner":"sol.Logger","id":"method-noop","meta":{"private":true}},{"name":"stringify","tagname":"method","owner":"sol.Logger","id":"method-stringify","meta":{"private":true}},{"name":"warn","tagname":"method","owner":"sol.Logger","id":"method-warn","meta":{}}],"code_type":"ext_define","id":"class-sol.Logger","short_doc":"This class provides extended and standardized logging capabilities for solution modules. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.Logger</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/lib_Class.html#sol-Logger' target='_blank'>lib_Class.js</a></div></pre><div class='doc-contents'><p>This class provides extended and standardized logging capabilities for solution modules. e.g.:</p>\n\n<ul>\n<li>Standardized outputs for all types</li>\n<li>Predefined scope for all log types</li>\n<li>String formatting operations for log messages</li>\n<li>Logging additional information thanks to js objects (JSON)</li>\n<li>Tracking execution times</li>\n</ul>\n\n\n<p>Logging operations are performed within a predefined scope.  The scope can be passed as a config param.</p>\n\n<pre><code>var logger = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a>\", { scope: 'custom.ix.MyClass' });\n</code></pre>\n\n<p>Please mind that all classes defined by <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a> inherit from <a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a> which initializes\na new logging instance by default.</p>\n\n<h1>Logging</h1>\n\n<p>Basic logging operations include debug, info, warn and error levels. While the first parameter 'messsage' is mandatory\na second parameter allows logging additional information with the help of an informationObject.\nIf such an object is passed the data is stringified to JSON and added to the log.</p>\n\n<p>The message can either be a string or an Array of Strings. If an array is passed a string formatter is used to replace\nall tokens in array[0] by additional items defined in the array array[1..].</p>\n\n<pre><code>// simple message as string.\nlogger.info(message, informationObject);\n\n// working with placeholders\nlogger.info([message, token1, token2], informationObject);\n</code></pre>\n\n<p>Following examples will illustrate some scenarios.</p>\n\n<pre><code>logger.info('Searching for elements...');\n// [custom.ix.MyClass] Searching for elements... :\n\nlogger.info('Searching for elements...', { parentId: 123 });\n// [custom.ix.MyClass] Searching for elements... : {\"parentId\":123}\n\nlogger.info(['Searching for elements of parentId: {0}', 123]);\n// [custom.ix.MyClass] Searching for elements of parentId: 123 :\n\nlogger.info(['Searching for elements of parentId: {0}', 123], {userName: 'Administrator'});\n// [custom.ix.MyClass] Searching for elements of parentId: 123 : {\"userName\":\"Administrator\"}\n</code></pre>\n\n<p>The same logic can be used for all logging types debug, info, warn and error.</p>\n\n<pre><code>logger.error(\"an error occurred\");\nlogger.warn([\"use default value= '{0}'\", defaultValue]);\nlogger.info([\"processing {0} (id={1})\", obj.name, obj.id]);\nlogger.debug(\"simple debug message\", { foo: \"bar\" });\n</code></pre>\n\n<h1>Log exceptions</h1>\n\n<p>In case of exceptions, the exception object can be passed as the information object.</p>\n\n<pre><code>logger.error(\"an error occurred\", ex);\n// [custom.ix.MyClass] an error occurred : File not found\n\nlogger.warn([ \"use default value= '{0}'\", defaultValue], ex);\n// [custom.ix.MyClass] use default value= '4711' : Could not read user ID\n</code></pre>\n\n<h1>Log execution of functions</h1>\n\n<p>The execution of functions can be logged in debug mode thanks to the enter and exit functions. The Logger measures\nthe execution time between enter and exit calls.</p>\n\n<pre><code>logger.enter(\"my.Function\");\nlogger.enter(\"my.Function\", informationObject);\n\nlogger.exit(\"my.Function\");\nlogger.exit(\"my.Function\", informationObject);\n</code></pre>\n\n<p>Following example shows a basic usage:</p>\n\n<pre><code>myFunction: function() {\n  var me = this;\n  me.logger.enter(\"my.Function\", { param: \"abc\" });  // Object optional\n  // function code belongs here.\n  me.logger.exit(\"my.Function\", { result: \"xyz\"});  // Object optional\n}\n\n// [custom.ix.MyClass] ENTER my.Function : {\"param\":\"abc\"}\n// [custom.ix.MyClass] EXIT my.Function : 313ms : {\"result\":\"xyz\"}\n</code></pre>\n\n<h1>Own logger implementation</h1>\n\n<p>The component should at least implement the following functions:</p>\n\n<ul>\n<li>error(String)</li>\n<li>warn(String)</li>\n<li>info(String)</li>\n<li>debug(String)</li>\n<li>isDebugEnabled() : Boolean</li>\n</ul>\n\n\n<p>You can use your own logger as follows:</p>\n\n<pre><code>var logger = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"<a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a>\", { scope: 'custom.ix.MyClass', logger: new MyLoggerImpl() });\n</code></pre>\n\n<h1>Troubleshooting</h1>\n\n<p>If class has no logging instance please ensure that if the class definition contains an\ninitialize param, the superclass' initialize function mus be called. e.g.</p>\n\n<pre><code><a href=\"#!/api/sol-static-method-define\" rel=\"sol-static-method-define\" class=\"docClass\">sol.define</a>(\"custom.ix.MyClass\", {\n  initialize: function(config) {\n    var me = this;\n    // logging instance is created in the superclass' initialize function\n    me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\n  }\n});\n</code></pre>\n\n<p>@todo Handlebars.js templates with lazy compile routine.</p>\n      <p class='version-tag'>Version: <b>1.1</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-logger' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-cfg-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-cfg-logger' class='name expandable'>logger</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) An own logger implementation can be supplied ...</div><div class='long'><p>(optional) An own logger implementation can be supplied</p>\n<p>Defaults to: <code>log|console</code></p></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-scope' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-cfg-scope' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-cfg-scope' class='name expandable'>scope</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>The scope will be logged with every log statement ...</div><div class='long'><p>The scope will be logged with every log statement</p>\n<p>Defaults to: <code>&#39;sol&#39;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-debugEnabled' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-property-debugEnabled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-property-debugEnabled' class='name expandable'>debugEnabled</a> : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Flag which saves the state of logger.isDebugEnabled ...</div><div class='long'><p>Flag which saves the state of logger.isDebugEnabled</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-pattern' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-property-pattern' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-property-pattern' class='name expandable'>pattern</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Patterns used by different logging types to generate an output. ...</div><div class='long'><p>Patterns used by different logging types to generate an output.</p>\n<p>Defaults to: <code>{error: &quot;[{{scope}}] {{msg}} : {{ex}}&quot;, warn: &quot;[{{scope}}] {{msg}} : {{ex}}&quot;, info: &quot;[{{scope}}] {{msg}} : {{object}}&quot;, debug: &quot;[{{scope}}] {{msg}} : {{object}}&quot;, enter: &quot;[{{scope}}] ENTER {{funct}} : {{object}}&quot;, exit: &quot;[{{scope}}] EXIT {{funct}} : {{time}}ms : {{object}}&quot;}</code></p></div></div></div><div id='property-timings' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-property-timings' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-property-timings' class='name expandable'>timings</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Internally handles timers for execution time calculations ...</div><div class='long'><p>Internally handles timers for execution time calculations</p>\n<p>Defaults to: <code>{}</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-debug' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-debug' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-debug' class='name expandable'>debug</a>( <span class='pre'>msg, obj</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs a message in DEBUG level. ...</div><div class='long'><p>Logs a message in DEBUG level.</p>\n\n<p>The message coude be a simple string or an Array, with a string with placeholders as first element, and the replacments as additional elements.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : String|Array<div class='sub-desc'><p>The message</p>\n</div></li><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>Optional object which will be printed after the message in serialized form</p>\n</div></li></ul></div></div></div><div id='method-doTiming' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-doTiming' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-doTiming' class='name expandable'>doTiming</a>( <span class='pre'>func</span> ) : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>func</span> : String<div class='sub-desc'><p>Name/Identifier for saving the start time</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-enter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-enter' class='name expandable'>enter</a>( <span class='pre'>funct, obj</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs a message in DEBUG level and starts the time meassurment for the function. ...</div><div class='long'><p>Logs a message in DEBUG level and starts the time meassurment for the function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funct</span> : String<div class='sub-desc'><p>The entered function</p>\n</div></li><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>Optional object which will be printed after the message in serialized form</p>\n</div></li></ul></div></div></div><div id='method-error' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-error' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-error' class='name expandable'>error</a>( <span class='pre'>msg, ex</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs a message in ERROR level. ...</div><div class='long'><p>Logs a message in ERROR level.</p>\n\n<p>The message coude be a simple string or an Array, with a string with placeholders as first element, and the replacments as additional elements.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : String|Array<div class='sub-desc'><p>The message</p>\n</div></li><li><span class='pre'>ex</span> : Exception<div class='sub-desc'><p>Optional exception parameter</p>\n</div></li></ul></div></div></div><div id='method-exit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-exit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-exit' class='name expandable'>exit</a>( <span class='pre'>funct, obj</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs a message in DEBUG level and finished the time meassurment for the function. ...</div><div class='long'><p>Logs a message in DEBUG level and finished the time meassurment for the function.</p>\n\n<p>The logged message contains the duration since the enter function was called.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>funct</span> : String<div class='sub-desc'><p>The entered function</p>\n</div></li><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>Optional object which will be printed after the message in serialized form</p>\n</div></li></ul></div></div></div><div id='method-format' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-format' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-format' class='name expandable'>format</a>( <span class='pre'>msg</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>If parameter is an Array, the first value will be treated as the String and all other elements will be inserted at th...</div><div class='long'><p>If parameter is an Array, the first value will be treated as the String and all other elements will be inserted at the placeholder positions in that String, maintaining their order.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : String|Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-info' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-info' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-info' class='name expandable'>info</a>( <span class='pre'>msg, obj</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs a message in INFO level. ...</div><div class='long'><p>Logs a message in INFO level.</p>\n\n<p>The message coude be a simple string or an Array, with a string with placeholders as first element, and the replacments as additional elements.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : String|Array<div class='sub-desc'><p>The message</p>\n</div></li><li><span class='pre'>obj</span> : Object<div class='sub-desc'><p>Optional object which will be printed after the message in serialized form\n@example</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-noop' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-noop' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-noop' class='name expandable'>noop</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-stringify' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-stringify' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-stringify' class='name expandable'>stringify</a>( <span class='pre'>obj</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : String|Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-warn' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.Logger'>sol.Logger</span><br/><a href='source/lib_Class.html#sol-Logger-method-warn' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Logger-method-warn' class='name expandable'>warn</a>( <span class='pre'>msg, ex</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Logs a message in WARN level. ...</div><div class='long'><p>Logs a message in WARN level.</p>\n\n<p>The message coude be a simple string or an Array, with a string with placeholders as first element, and the replacments as additional elements.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>msg</span> : String|Array<div class='sub-desc'><p>The message</p>\n</div></li><li><span class='pre'>ex</span> : Exception<div class='sub-desc'><p>Optional exception parameter</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloall":true}});